#include <string.h>
#include <ctype.h>
#include <stdio.h>
char* StringMid(char* iString,int Start,int Count);
char* StringLeft(char* iString,int Count);
char* StringRight(char* iString,int Count);
char* StringStripWS(char* iString);
char* StringAdd(char* StrA,char* StrB);
char* StringUpper(char* iString);
int CharIsSpace(char* CharA);
int StringIsCRLF(char* iString);
int StringExceedsCRLF(char* Text,int Pos);
char* CRLF();
int IsSection(char* Text,char* Section);
int IsKey(char* Text,char* Key,int Pos);
int IsNewSection(char* Text,int Pos);
char* StringIniWrite(char* Text,char* Section,char* Key,char* Value);
char* StringIniRead(char* Text,char* Section,char* Key,char* iDefault);
int FileIniWrite(char* FileFullName,char* Section,char* Key,char* Value);
char* FileIniRead(char* Text,char* Section,char* Key,char* iDefault);

int FileIniWrite(char* FileFullName,char* Section,char* Key,char* Value)
{
FILE * pFile = fopen (FileFullName,"rb");
if (pFile == NULL )
{
FILE * nFile = fopen (FileFullName,"wb");
if (nFile == NULL) return 0;
char* Text = StringIniWrite("",Section,Key,Value);
fwrite(Text,1,strlen(Text) + 1,nFile);
fclose(nFile);
} else {
fseek(pFile,0,SEEK_END);
int FileSize = ftell(pFile);
rewind(pFile);
char* Text = new char[FileSize];
ZeroMemory(Text,FileSize);
fread(Text,FileSize,1,pFile);
Text = StringIniWrite(Text,Section,Key,Value);
fclose(pFile);
pFile = fopen (FileFullName,"wb");
if (pFile == NULL) return 0;
fwrite(Text,1,strlen(Text) + 1,pFile);
fclose(pFile);
}

return 1;
}

char* FileIniRead(char* FileFullName,char* Section,char* Key,char* iDefault)
{
FILE * pFile = fopen (FileFullName,"rb");
if (pFile == NULL ) return iDefault;
fseek(pFile,0,SEEK_END);
int FileSize = ftell(pFile);
rewind(pFile);
char* Text = new char[FileSize];
ZeroMemory(Text,FileSize);
fread(Text,FileSize,1,pFile);
fclose(pFile);
return StringIniRead(Text,Section,Key,iDefault);
}

char* StringIniRead(char* Text,char* Section,char* Key,char* iDefault)
{
Section = StringStripWS(Section);
Key = StringStripWS(Key);
int TLen = strlen(Text);
int PosA = IsSection(Text,Section);
if (PosA)
{
int PosB = IsKey(Text,Key,PosA);
if (PosB)
{
for (int A = PosB; A <= TLen ; A++)
{
char* CharA = StringMid(Text,A,2);
if ((StringIsCRLF(CharA)) || A == TLen)
return StringMid(Text,(PosB + 1),A - (PosB + 1));
}
}else {
return iDefault;
}
}
return iDefault;
}

char* StringIniWrite(char* Text,char* Section,char* Key,char* Value)
{
Section = StringStripWS(Section);
Key = StringStripWS(Key);
int TLen = strlen(Text);
int PosA = IsSection(Text,Section);
if (PosA)
{
int PosB = IsKey(Text,Key,PosA);
if (PosB)
{
for (int A = PosB; A <= TLen ; A++)
{
char* CharA = StringMid(Text,A,2);
if ((StringIsCRLF(CharA)) || A == TLen)
{
if (StringIsCRLF(CharA)) A--;
char* TextA = StringLeft(Text,PosB);
char* TextB = StringRight(Text,TLen - A);
TextA = StringAdd(TextA,Value);
TextA = StringAdd(TextA,TextB);
return TextA;
}
}
}else {
char* CharB = StringMid(Text,PosA,2);
if (StringIsCRLF(CharB)) PosA++;
char* TextA = StringLeft(Text,PosA);
char* TextB = StringRight(Text,TLen - PosA);
if (!StringIsCRLF(CharB)) TextA = StringAdd(TextA,CRLF());
TextA = StringAdd(TextA,Key);
TextA = StringAdd(TextA,"=");
TextA = StringAdd(TextA,Value);
TextA = StringAdd(TextA,CRLF());
TextA = StringAdd(TextA,TextB);
return TextA;
}
}
char* CharC = StringRight(Text,2);
if (!StringIsCRLF(CharC)) Text = StringAdd(Text,CRLF());
Text = StringAdd(Text,"[");
Text = StringAdd(Text,Section);
Text = StringAdd(Text,"]");
Text = StringAdd(Text,CRLF());
Text = StringAdd(Text,Key);
Text = StringAdd(Text,"=");
Text = StringAdd(Text,Value);
Text = StringAdd(Text,CRLF());
return Text;
}

int IsSection(char* Text,char* Section)
{
int TLen = strlen(Text);
int SLen = strlen(Section);
int ExitLoop = 0;
Section = StringUpper(Section);
for (int A = 1; A <= TLen ; A++)
{
ExitLoop = 0;
char* CharA = StringMid(Text,A,2);
if ((StringIsCRLF(CharA)) || A == 1)
{
A = StringExceedsCRLF(Text,A);
for (int B = A; B <= TLen ; B++)
{
char* CharB = StringMid(Text,B,1);
if (!CharIsSpace(CharB))
{
for (int C = B; C <= TLen ; C++)
{
char* CharC = StringMid(Text,C,1);
if (strcmp(CharC,"[") == 0)
{
for (int D = C + 1; D <= TLen ; D++)
{
char* CharD = StringMid(Text,D,1);
if (!CharIsSpace(CharD))
{
if (strcmp(StringUpper(StringMid(Text,D,SLen)),Section) == 0)
{
for (int E = D + SLen; E <= TLen ; E++)
{
char* CharE = StringMid(Text,E,1);
if (!CharIsSpace(CharE))
{
for (int F = E; F <= TLen ; F++)
{
char* CharF = StringMid(Text,F,1);
if (strcmp(CharF,"]") == 0)
{
if (F == TLen) return F;
for (int G = F + 1; G <= TLen ; G++)
{
char* CharG = StringMid(Text,G,1);
char* CharH = StringMid(Text,G,2);
if (!CharIsSpace(CharG))
{
if (StringIsCRLF(CharH))
{
return G;
} else {
if (G == TLen) return G;
ExitLoop = 1;
break;
}
}
if (G == TLen) return G;
if (ExitLoop == 1) break;
}
} else {
ExitLoop = 1;
}
if (F == TLen) return 0;
if (ExitLoop == 1) break;
}
}
if (E == TLen) return 0;
if (ExitLoop == 1) break;
}
} else {
ExitLoop = 1;
}
}
if (D == TLen) return 0;
if (ExitLoop == 1) break;
}
} else {
ExitLoop = 1;
}
if (C == TLen) return 0;
if (ExitLoop == 1) break;
}
}
if (B == TLen) return 0;
if (ExitLoop == 1) break;
}
}
if (A == TLen) return 0;
}
return 0;
}

int IsNewSection(char* Text,int Pos)
{
int TLen = strlen(Text);
for (int A = Pos; A <= TLen ; A++)
{
char* CharA = StringMid(Text,A,2);
if (StringIsCRLF(CharA))
{
A = StringExceedsCRLF(Text,A);
for (int B = A; B <= TLen ; B++)
{
char* CharB = StringMid(Text,B,1);
if (!CharIsSpace(CharB))
{
for (int C = B; C <= TLen ; C++)
{
char* CharC = StringMid(Text,C,1);
if (strcmp(CharC,"[") == 0)
{
for (int D = C + 1; D <= TLen ; D++)
{
char* CharD = StringMid(Text,D,1);
char* CharE = StringMid(Text,D,2);
if (StringIsCRLF(CharE) || D == TLen) return 0;
if (strcmp(CharD,"]") == 0)
{
for (int E = D + 1; E <= TLen ; E++)
{
char* CharF = StringMid(Text,E,1);
char* CharG = StringMid(Text,E,2);
if (!CharIsSpace(CharF))
{
if (StringIsCRLF(CharG) || E == TLen)
{
return E;
} else {
return 0;
}
}
}
if (D == TLen) return D;
}
if (D == TLen) return 0;
}
} else {
return 0;
}
if (C == TLen) return 0;
}
}
if (B == TLen) return 0;
}
}
if (A == TLen) return 0;
}
return 0;
}

int IsKey(char* Text,char* Key,int Pos)
{
int TLen = strlen(Text);
int KLen = strlen(Key);
int ExitLoop = 0;
Key = StringUpper(Key);
for (int A = Pos; A <= TLen ; A++)
{
char* CharA = StringMid(Text,A,1);
if (!CharIsSpace(CharA))
{
for (int B = A; B <= TLen ; B++)
{
ExitLoop = 0;
char* CharB = StringMid(Text,B,2);
if (StringIsCRLF(CharB))
{
if (IsNewSection(Text,B)) return 0;
B = StringExceedsCRLF(Text,B);
for (int C = B; C <= TLen ; C++)
{
char* CharC = StringMid(Text,C,1);
if (!CharIsSpace(CharC))
{
for (int D = C; D <= TLen ; D++)
{
if (strcmp(StringUpper(StringMid(Text,D,KLen)),Key) == 0)
{
for (int E = D + KLen; E <= TLen ; E++)
{
char* CharD = StringMid(Text,E,1);
if (!CharIsSpace(CharD))
{
for (int F = E; F <= TLen ; F++)
{
char* CharE = StringMid(Text,F,1);
if (strcmp(CharE,"=") == 0)
{
return F;
} else {
ExitLoop = 1;
}
if (ExitLoop == 1) break;
}
}
if (ExitLoop == 1) break;
}
} else {
ExitLoop = 1;
}
if (ExitLoop == 1) break;
}
}
if (ExitLoop == 1) break;
}
}
}
}
}
return 0;
}

char* StringMid(char* iString,int Start,int Count)
{
int len = strlen(iString) , iCount = Count;
if (Start > len || Start < 0 || Count < 1) return "";
if (Count > (len - Start)) iCount == (len - Start);
return StringRight(StringLeft(iString,(Start + iCount) - 1),iCount);
}

char* StringLeft(char* iString,int Count)
{
if (Count < 1 ) return "";
if (Count > strlen(iString)) Count = strlen(iString);
char* StrA = new char[Count + 1];
strncpy(StrA,iString,Count);
StrA[Count]='\0';
return StrA;
}

char* StringRight(char* iString,int Count)
{
if (Count < 1 ) return "";
if (Count > strlen(iString)) Count = strlen(iString);
char* StrA = new char[Count + 1];
strncpy(StrA,iString + (strlen(iString) - Count),Count);
StrA[Count]='\0';
return StrA;
}

char* StringUpper(char* iString)
{
char* pString = new char[strlen(iString)];
for ( int i = 0 ; i <= strlen(iString) ; i++ )
pString[i] = toupper(iString[i]);
return pString;
}

char* StringStripWS(char* iString)
{
char* StrA = iString;
for ( int A = 0 ; A <= strlen(iString) ; A++ )
{
if (iString[A] == (char) 32) {StrA = StringRight(iString,strlen(iString) - A);} else {break;}
}
char* StrB = StrA;
for ( int A = strlen(StrA) ; A >= 0 ; A--)
{
if (StrA[A] == (char) 32) {StrB = StringLeft(StrA,A);} else {break;}
}
return StrB;
}

int StringIsCRLF(char* iString)
{
if (strcmp(iString ,CRLF()) == 0) return 1;
return 0;
}

int CharIsSpace(char* CharA)
{
if (strcmp(CharA," ") == 0) return 1;
return 0;
}

int StringExceedsCRLF(char* Text,int Pos)
{
int A = Pos;
int TLen = strlen(Text);
while (A != TLen)
{
char* CharA = StringMid(Text,A,1);
if (strcmp(CharA,"\r") != 0 && strcmp(CharA,"\n") != 0) break;
A++;
}
return A;
}

char* CRLF()
{
return StringAdd("\r","\n");
}

char* StringAdd(char* StrA,char* StrB)
{
char* StrC = new char[strlen(StrA) + strlen(StrB) + 1];
strcpy(StrC,StrA);
strcpy(StrC + strlen(StrA),StrB);
return StrC;
}
